/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.media;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import net.sourceforge.peers.Logger;

public abstract class Encoder
implements Runnable {
    private PipedInputStream rawData;
    private PipedOutputStream encodedData;
    private boolean isStopped;
    private FileOutputStream encoderOutput;
    private FileOutputStream encoderInput;
    private boolean mediaDebug;
    private Logger logger;
    private String peersHome;
    private CountDownLatch latch;

    public Encoder(PipedInputStream rawData, PipedOutputStream encodedData, boolean mediaDebug, Logger logger, String peersHome, CountDownLatch latch) {
        this.rawData = rawData;
        this.encodedData = encodedData;
        this.mediaDebug = mediaDebug;
        this.logger = logger;
        this.peersHome = peersHome;
        this.latch = latch;
        this.isStopped = false;
    }

    @Override
    public void run() {
        if (this.mediaDebug) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String date = simpleDateFormat.format(new Date());
            String dir = this.peersHome + File.separator + "media" + File.separator;
            String fileName = dir + date + "_g711_encoder.output";
            try {
                this.encoderOutput = new FileOutputStream(fileName);
                fileName = dir + date + "_g711_encoder.input";
                this.encoderInput = new FileOutputStream(fileName);
            }
            catch (FileNotFoundException e) {
                this.logger.error("cannot create file", e);
                return;
            }
        }
        while (!this.isStopped) {
            byte[] buffer;
            try {
                int ready = this.rawData.available();
                while (ready == 0 && !this.isStopped) {
                    try {
                        Thread.sleep(2L);
                        ready = this.rawData.available();
                    }
                    catch (InterruptedException e) {
                        this.logger.error("interrupt exception", e);
                    }
                }
                if (this.isStopped) break;
                buffer = new byte[ready];
                this.rawData.read(buffer);
                if (this.mediaDebug) {
                    try {
                        this.encoderInput.write(buffer);
                    }
                    catch (IOException e) {
                        this.logger.error("cannot write to file", e);
                    }
                }
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
                return;
            }
            byte[] ulawData = this.process(buffer);
            if (this.mediaDebug) {
                try {
                    this.encoderOutput.write(ulawData);
                }
                catch (IOException e) {
                    this.logger.error("cannot write to file", e);
                    break;
                }
            }
            try {
                this.encodedData.write(ulawData);
                this.encodedData.flush();
            }
            catch (IOException e) {
                this.logger.error("input/output error", e);
                return;
            }
        }
        if (this.mediaDebug) {
            try {
                this.encoderOutput.close();
                this.encoderInput.close();
            }
            catch (IOException e) {
                this.logger.error("cannot close file", e);
                return;
            }
        }
        this.latch.countDown();
        if (this.latch.getCount() != 0L) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                this.logger.error("interrupt exception", e);
            }
        }
    }

    public synchronized void setStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public abstract byte[] process(byte[] var1);
}

